/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.documentation.entry;

import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.documentation.DocClientUtils;
import com.hollingsworth.arsnouveau.api.documentation.SinglePageCtor;
import com.hollingsworth.arsnouveau.api.documentation.SinglePageWidget;
import com.hollingsworth.arsnouveau.api.documentation.export.DocExporter;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.gui.documentation.BaseDocScreen;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class EntityEntry
extends SinglePageWidget {
    EntityType<?> entityType;
    Component description;
    float scale;
    LivingEntity entity;
    int yOffset = 0;

    public EntityEntry(EntityType<? extends LivingEntity> entityType, Component description, float scale, BaseDocScreen parent, int x, int y, int width, int height, int yOffset) {
        super(parent, x, y, width, height);
        this.entityType = entityType;
        this.description = description;
        this.scale = scale;
        this.entity = (LivingEntity)entityType.create((Level)parent.getMinecraft().level);
        this.yOffset = yOffset;
    }

    public static SinglePageCtor create(EntityType<? extends LivingEntity> entityType) {
        return (parent, x, y, width, height) -> new EntityEntry(entityType, (Component)Component.empty(), 1.0f, parent, x, y, width, height, 0);
    }

    public static SinglePageCtor create(EntityType<? extends LivingEntity> entityType, Component description) {
        return (parent, x, y, width, height) -> new EntityEntry(entityType, description, 1.0f, parent, x, y, width, height, 0);
    }

    public static SinglePageCtor create(EntityType<? extends LivingEntity> entityType, Component description, float scale) {
        return (parent, x, y, width, height) -> new EntityEntry(entityType, description, scale, parent, x, y, width, height, 0);
    }

    public static SinglePageCtor create(EntityType<? extends LivingEntity> entityType, Component description, float scale, int yOffset) {
        return (parent, x, y, width, height) -> new EntityEntry(entityType, description, scale, parent, x, y, width, height, yOffset);
    }

    @Override
    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        DocClientUtils.blit(guiGraphics, DocAssets.IMAGE_FRAME, this.x + 4, this.y + 10);
        DocClientUtils.drawHeaderNoUnderline(this.entityType.getDescription(), guiGraphics, this.x, this.y, this.width, mouseX, mouseY, partialTick);
        if (this.description != null) {
            DocClientUtils.drawParagraph(this.description, guiGraphics, this.x, this.y + 100, this.width, mouseX, mouseY, partialTick);
        }
        float entityWidth = this.entity.getBbWidth();
        float entityHeight = this.entity.getBbHeight();
        float entitySize = Math.max(1.0f, Math.max(entityWidth, entityHeight));
        float renderScale = 100.0f / entitySize * 0.6f * this.scale;
        float offset = Math.max(entityHeight, entitySize) * 0.5f + (float)this.yOffset;
        EntityEntry.renderEntity(guiGraphics, (Entity)this.entity, (float)this.x + (float)this.width / 2.0f, (float)this.y + offset + 80.0f, (float)ClientInfo.ticksInGame + partialTick, renderScale, 0.0f);
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
    }

    public static void renderEntity(GuiGraphics graphics, Entity entity, float x, float y, float rotation, float renderScale, float offset) {
        PoseStack ms = graphics.pose();
        ms.pushPose();
        ms.translate(x, y, 50.0f);
        ms.scale(renderScale, renderScale, renderScale);
        ms.translate(0.0f, offset, 0.0f);
        ms.mulPose(Axis.ZP.rotationDegrees(180.0f));
        ms.mulPose(Axis.YP.rotationDegrees(rotation));
        Lighting.setupForEntityInInventory();
        EntityRenderDispatcher erd = Minecraft.getInstance().getEntityRenderDispatcher();
        MultiBufferSource.BufferSource immediate = Minecraft.getInstance().renderBuffers().bufferSource();
        erd.setRenderShadow(false);
        erd.render(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, ms, (MultiBufferSource)immediate, 0xF000F0);
        erd.setRenderShadow(true);
        immediate.endBatch();
        ms.popPose();
        Lighting.setupFor3DItems();
    }

    @Override
    public void addExportProperties(JsonObject object) {
        super.addExportProperties(object);
        if (this.description != null) {
            object.addProperty(DocExporter.DESCRIPTION_PROPERTY, this.description.getString());
        }
        object.addProperty(DocExporter.ENTITY_PROPERTY, BuiltInRegistries.ENTITY_TYPE.getKey(this.entityType).toString());
    }
}

